#include <d3d8.h>

#include ".\GSGame.h"
#include ".\GSMenu.h"
#include ".\GSDone.h"
#include ".\LD10.h"



CGSGame::CGSGame()
{

  m_ButtonReleased = false;

  m_BuildMode = true;
  m_GoPushed = false;
  m_pSelectedBomb = NULL;
  /*
  m_BombsLeft = 10;

  for ( int i = 0; i < 3; ++i )
  {
    GameObject    Bomb;

    Bomb.m_X = ( rand() % 560 ) + 40.0f;
    Bomb.m_Y = ( rand() % 400 ) + 40.0f;
    Bomb.m_Texture = LD10::TEX_TIMEBOMB_8;
    Bomb.m_Type = LD10::GO_TIMEBOMB;
    Bomb.m_LifeTime = ( rand() % 8 ) * ( 5.0f / 9.0f );
    Bomb.m_Texture = (LD10::TextureTypes)( LD10::TEX_TIMEBOMB_8 + (int)( Bomb.m_LifeTime / ( 5.0f / 9.0f ) ) );

    m_Level.m_Objects.push_back( Bomb );
  }
  for ( int i = 0; i < 5; ++i )
  {
    GameObject    Diamond;

    Diamond.m_X = ( rand() % 560 ) + 40.0f;
    Diamond.m_Y = ( rand() % 400 ) + 40.0f;
    Diamond.m_Texture = LD10::TEX_STEEL_DIAMOND;
    Diamond.m_Type = LD10::GO_STEEL_DIAMOND;

    m_Level.m_Objects.push_back( Diamond );
  }
  */
  m_CurLevel = 1;

  m_Level.Load( m_CurLevel );

  m_BombsLeft = m_Level.m_BombsAvailable;
  m_ShowName = true;

}



CGSGame::~CGSGame()
{
}



void CGSGame::Display( IDirect3DDevice8* pDevice )
{

  D3DVIEWPORT8    ViewPort;

  ViewPort.X = 0;
  ViewPort.Y = 0;
  ViewPort.Width = 640;
  ViewPort.Height = 440;
  ViewPort.MinZ = 0.0f;
  ViewPort.MaxZ = 1.0f;

  theApp.m_pd3dDevice->SetViewport( &ViewPort );

  m_Level.Render();

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHATESTENABLE, TRUE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  // display clipped stuff
  if ( ( m_BuildMode )
  &&   ( !m_ShowName ) )
  {
    if ( m_pSelectedBomb )
    {
      theApp.RenderTextureSection( m_pSelectedBomb->m_DispX - 14, m_pSelectedBomb->m_DispY - 13, theApp.m_TexSec[LD10::TEX_BOMB_SELECTOR] );
    }

    theApp.RenderTextureSection( theApp.m_MouseX - 13, theApp.m_MouseY - 12, theApp.m_TexSec[LD10::TEX_BOMB] );
  }

  ViewPort.Height = 480;
  theApp.m_pd3dDevice->SetViewport( &ViewPort );

  if ( m_ShowName )
  {
    theApp.PrintNiceCentered( 320, 201, m_Level.m_Name.c_str(), 0xff000000 );
    theApp.PrintNiceCentered( 320, 199, m_Level.m_Name.c_str(), 0xff000000 );
    theApp.PrintNiceCentered( 319, 200, m_Level.m_Name.c_str(), 0xff000000 );
    theApp.PrintNiceCentered( 321, 200, m_Level.m_Name.c_str(), 0xff000000 );
    theApp.PrintNiceCentered( 320, 200, m_Level.m_Name.c_str() );
  }
  else if ( m_BuildMode )
  {
    char      szTemp[200];

    wsprintf( szTemp, "Bombs: %d", m_BombsLeft );
    theApp.PrintNice( 101, 443, szTemp, 0xff000000 );
    theApp.PrintNice( 100, 442, szTemp );

    theApp.Print( 240, 442, "Use the left mouse button to set or select a bomb, right to remove" );
    theApp.Print( 240, 461, "Once selected you can use the cursor keys to move a bomb" );

    if ( ( theApp.m_MouseX >= 0 )
    &&   ( theApp.m_MouseX < 64 )
    &&   ( theApp.m_MouseY >= 440 )
    &&   ( theApp.m_MouseY < 480 ) )
    {
      if ( theApp.m_MouseButtons & 1 )
      {
        theApp.RenderTextureSection( 0, 440, theApp.m_TexSec[LD10::TEX_GO_3] );
      }
      else
      {
        theApp.RenderTextureSection( 0, 440, theApp.m_TexSec[LD10::TEX_GO_2] );
      }
    }
    else
    {
      theApp.RenderTextureSection( 0, 440, theApp.m_TexSec[LD10::TEX_GO_1] );
    }
  }
  else
  {
    if ( m_Level.IsSolved() )
    {
      theApp.PrintNiceCentered( 320, 140, "Stage Solved", 0xffffffff );
      if ( ( theApp.m_MouseX >= 0 )
      &&   ( theApp.m_MouseX < 64 )
      &&   ( theApp.m_MouseY >= 440 )
      &&   ( theApp.m_MouseY < 480 ) )
      {
        if ( theApp.m_MouseButtons & 1 )
        {
          theApp.RenderTextureSection( 0, 440, theApp.m_TexSec[LD10::TEX_NEXT_3] );
        }
        else
        {
          theApp.RenderTextureSection( 0, 440, theApp.m_TexSec[LD10::TEX_NEXT_2] );
        }
      }
      else
      {
        theApp.RenderTextureSection( 0, 440, theApp.m_TexSec[LD10::TEX_NEXT_1] );
      }
    }
    else
    {
      // Editor-Button
      if ( ( theApp.m_MouseX >= 0 )
      &&   ( theApp.m_MouseX < 64 )
      &&   ( theApp.m_MouseY >= 440 )
      &&   ( theApp.m_MouseY < 480 ) )
      {
        if ( theApp.m_MouseButtons & 1 )
        {
          theApp.RenderTextureSection( 0, 440, theApp.m_TexSec[LD10::TEX_EDITOR_3] );
        }
        else
        {
          theApp.RenderTextureSection( 0, 440, theApp.m_TexSec[LD10::TEX_EDITOR_2] );
        }
      }
      else
      {
        theApp.RenderTextureSection( 0, 440, theApp.m_TexSec[LD10::TEX_EDITOR_1] );
      }
    }
  }

}



void CGSGame::UpdateFrame( const float fElapsedTime )
{

  if ( m_BuildMode )
  {
  }
  else
  {
    m_Level.Update( fElapsedTime );
  }

}



void CGSGame::OnChar( int iChar )
{

  if ( iChar == 27 )
  {
    if ( !m_BuildMode )
    {
      // back to build mode
      BackToBuildMode();
    }
    else
    {
      // TODO - submenu!
      theApp.NextState( new CGSMenu() );
    }
  }
  else if ( iChar == 'c' )
  {
    m_CurLevel++;
    if ( !m_Level.Load( m_CurLevel ) )
    {
      theApp.NextState( new CGSDone() );
    }
    else
    {
      m_pSelectedBomb = NULL;
      m_SelectedBombIndex = -1;
      m_ListSetBombs.clear();
      BackToBuildMode();
      m_ShowName = true;
    }
  }

}



void CGSGame::OnKeyDown( int iChar )
{

  if ( iChar == VK_LEFT )
  {
    if ( ( m_BuildMode )
    &&   ( m_pSelectedBomb ) )
    {
      CalcSelectedBombIndex();
      if ( m_pSelectedBomb->m_DispX > 10 )
      {
        if ( m_Level.CanAreaContainBomb( m_pSelectedBomb->m_DispX - 1, m_pSelectedBomb->m_DispY, 25, 25 ) )
        {
          m_ListSetBombs[m_SelectedBombIndex].first--;
          m_pSelectedBomb->m_DispX--;
        }
      }
    }
  }
  else if ( iChar == VK_RIGHT )
  {
    if ( ( m_BuildMode )
    &&   ( m_pSelectedBomb ) )
    {
      CalcSelectedBombIndex();
      if ( m_pSelectedBomb->m_DispX < 630 )
      {
        if ( m_Level.CanAreaContainBomb( m_pSelectedBomb->m_DispX + 1, m_pSelectedBomb->m_DispY, 25, 25 ) )
        {
          m_ListSetBombs[m_SelectedBombIndex].first++;
          m_pSelectedBomb->m_DispX++;
        }
      }
    }
  }
  else if ( iChar == VK_UP )
  {
    if ( ( m_BuildMode )
    &&   ( m_pSelectedBomb ) )
    {
      CalcSelectedBombIndex();
      if ( m_pSelectedBomb->m_DispY > 10 )
      {
        if ( m_Level.CanAreaContainBomb( m_pSelectedBomb->m_DispX, m_pSelectedBomb->m_DispY - 1, 25, 25 ) )
        {
          m_ListSetBombs[m_SelectedBombIndex].second--;
          m_pSelectedBomb->m_DispY--;
        }
      }
    }
  }
  else if ( iChar == VK_DOWN )
  {
    if ( ( m_BuildMode )
    &&   ( m_pSelectedBomb ) )
    {
      CalcSelectedBombIndex();
      if ( m_pSelectedBomb->m_DispY < 430 )
      {
        if ( m_Level.CanAreaContainBomb( m_pSelectedBomb->m_DispX, m_pSelectedBomb->m_DispY + 1, 25, 25 ) )
        {
          m_ListSetBombs[m_SelectedBombIndex].second++;
          m_pSelectedBomb->m_DispY++;
        }
      }
    }
  }

}



void CGSGame::OnMouse( int iX, int iY, int iButtons )
{

  if ( m_ShowName )
  {
    if ( ( iButtons & 1 )
    &&   ( m_ButtonReleased ) )
    {
      m_ButtonReleased = false;
      m_ShowName = false;
    }
  }
  else if ( m_BuildMode )
  {
    if ( theApp.m_MouseY < 440 )
    {
      if ( ( iButtons & 1 )
      &&   ( m_ButtonReleased ) )
      {
        m_ButtonReleased = false;

        bool    SelectedBomb = false;

        Level::tListObjects::iterator   itObj( m_Level.m_Objects.begin() );
        while ( itObj != m_Level.m_Objects.end() )
        {
          GameObject& Obj( *itObj );

          if ( ( abs( Obj.m_DispX - theApp.m_MouseX ) < 20 )
          &&   ( abs( Obj.m_DispY - theApp.m_MouseY ) < 20 ) )
          {
            std::vector<std::pair<int,int> >::iterator    itSetBombs( m_ListSetBombs.begin() );
            while ( itSetBombs != m_ListSetBombs.end() )
            {
              if ( ( itSetBombs->first == Obj.m_DispX )
              &&   ( itSetBombs->second == Obj.m_DispY ) )
              {
                m_pSelectedBomb = &Obj;
                SelectedBomb = true;
                break;
              }

              ++itSetBombs;
            }
            break;
          }

          ++itObj;
        }

        if ( !SelectedBomb )
        {
          if ( m_BombsLeft > 0 )
          {
            if ( m_Level.m_Field[iX / 20][iY / 20] == LD10::TILE_EMPTY )
            {
              GameObject*    pBomb = m_Level.CreateObject( LD10::GO_BOMB );

              pBomb->m_DispX = iX;
              pBomb->m_DispY = iY;

              m_BombsLeft--;

              m_ListSetBombs.push_back( std::make_pair( iX, iY ) );

              m_pSelectedBomb = pBomb;

              theApp.PlaySound( LD10::SOUND_PUTDOWN );
            }
            else
            {
              theApp.PlaySound( LD10::SOUND_NO_GO );
            }
          }
        }
      }
      else if ( iButtons & 2 )
      {
        // delete a bomb
        bool    DeletedBomb = false;

        Level::tListObjects::iterator   itObj( m_Level.m_Objects.begin() );
        while ( itObj != m_Level.m_Objects.end() )
        {
          GameObject& Obj( *itObj );

          if ( ( abs( Obj.m_DispX - theApp.m_MouseX ) < 20 )
          &&   ( abs( Obj.m_DispY - theApp.m_MouseY ) < 20 ) )
          {
            std::vector<std::pair<int,int> >::iterator    itSetBombs( m_ListSetBombs.begin() );
            while ( itSetBombs != m_ListSetBombs.end() )
            {
              if ( ( itSetBombs->first == Obj.m_DispX )
              &&   ( itSetBombs->second == Obj.m_DispY ) )
              {
                m_ListSetBombs.erase( itSetBombs );
                m_BombsLeft++;
                m_Level.m_Objects.erase( itObj );
                if ( m_pSelectedBomb == &Obj )
                {
                  m_pSelectedBomb = NULL;
                }
                DeletedBomb = true;
                theApp.PlaySound( LD10::SOUND_PUTDOWN );
                break;
              }

              ++itSetBombs;
            }
          }

          if ( DeletedBomb )
          {
            break;
          }
          ++itObj;
        }
      }
    }
    else if ( iButtons & 1 )
    {
      if ( ( theApp.m_MouseX >= 0 )
      &&   ( theApp.m_MouseX < 64 )
      &&   ( theApp.m_MouseY >= 440 )
      &&   ( theApp.m_MouseY < 480 ) )
      {
        m_GoPushed = true;
      }
      else
      {
        m_GoPushed = false;
      }
    }
  }
  else
  {
    if ( theApp.m_MouseY >= 440 )
    {
      if ( iButtons & 1 )
      {
        if ( ( theApp.m_MouseX >= 0 )
        &&   ( theApp.m_MouseX < 64 )
        &&   ( theApp.m_MouseY >= 440 )
        &&   ( theApp.m_MouseY < 480 ) )
        {
          m_GoPushed = true;
        }
        else
        {
          m_GoPushed = false;
        }
      }
    }
  }

  if ( !( iButtons & 1 ) )
  {
    if ( ( theApp.m_MouseX >= 0 )
    &&   ( theApp.m_MouseX < 64 )
    &&   ( theApp.m_MouseY >= 440 )
    &&   ( theApp.m_MouseY < 480 ) )
    {
      if ( m_GoPushed )
      {
        m_GoPushed = false;
        if ( m_BuildMode )
        {
          m_BuildMode = false;
          CalcSelectedBombIndex();
          m_pSelectedBomb = NULL;
        }
        else if ( m_Level.IsSolved() )
        {
          // Level solved, go to next
          m_CurLevel++;
          if ( !m_Level.Load( m_CurLevel ) )
          {
            theApp.NextState( new CGSDone() );
          }
          else
          {
            m_pSelectedBomb = NULL;
            m_SelectedBombIndex = -1;
            m_ListSetBombs.clear();
            BackToBuildMode();
            m_ShowName = true;
          }
        }
        else
        {
          BackToBuildMode();
        }
      }
    }
    m_ButtonReleased = true;
  }

}



void CGSGame::CalcSelectedBombIndex()
{

  if ( m_pSelectedBomb )
  {
    // store selected bomb index
    m_SelectedBombIndex = 0;
    std::vector<std::pair<int,int> >::iterator    it( m_ListSetBombs.begin() );
    while ( it != m_ListSetBombs.end() )
    {
      if ( ( it->first == m_pSelectedBomb->m_DispX )
      &&   ( it->second == m_pSelectedBomb->m_DispY ) )
      {
        break;
      }

      ++it;
      ++m_SelectedBombIndex;
    }
  }
  else
  {
    m_SelectedBombIndex = -1;
  }

}



void CGSGame::BackToBuildMode()
{

  m_BuildMode = true;

  m_Level.Load( m_CurLevel );

  m_BombsLeft = m_Level.m_BombsAvailable;

  // Rebuild already set bombs
  int   CurIndex = 0;
  std::vector<std::pair<int,int> >::iterator    it( m_ListSetBombs.begin() );
  while ( it != m_ListSetBombs.end() )
  {
    GameObject*    pBomb = m_Level.CreateObject( LD10::GO_BOMB );

    pBomb->m_DispX = it->first;
    pBomb->m_DispY = it->second;

    m_BombsLeft--;

    if ( CurIndex == m_SelectedBombIndex )
    {
      m_pSelectedBomb = pBomb;
    }

    ++CurIndex;
    ++it;
  }

}